﻿using System;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.ServiceLocation;

namespace Shell
{
    internal class ViewModelContentLoader : RegionNavigationContentLoader
    {
        private IServiceLocator serviceLocator;

        public ViewModelContentLoader(IServiceLocator serviceLocator)
            :base(serviceLocator)
        {
       
        }

        protected override string GetContractFromNavigationContext(NavigationContext navigationContext)
        {

            string contract = base.GetContractFromNavigationContext(navigationContext);

            if (contract.Equals("ModuleBView", StringComparison.OrdinalIgnoreCase))
            {
                return typeof(ModuleA.ModuleAView).Name;
            }

            if (contract.Equals("ModuleAView", StringComparison.OrdinalIgnoreCase))
            {
                return typeof(ModuleB.ModuleBView).Name;
            }

            return contract;
        }
    }
}